package jp.mosp.common.part;

import java.text.NumberFormat;

import jp.mosp.common.common.ValidateUtility;

/**
 * ɊւPartNX
 * @author yoshida
 * 	@version	0.0.1
 */
public class NumberPart {

	/**
	 * tH[}bg
	 * @param number 
	 * @param max ő包
	 * @param min _ȉő包
	 * @return ()
	 */
	public static String getNumberString(double number, int integer, int fraction) {
		NumberFormat nf = NumberFormat.getNumberInstance();
		nf.setMaximumIntegerDigits(integer);
		nf.setMaximumFractionDigits(fraction);
		return nf.format(number);
	}

	/**
	 * ϊ
	 * @param input		ϊO
	 * @return	ϊ㐮
	 */
	public static int getIntParam(String input) {
		int num = 0;
		if (StringPart.isNotNull(input)) {
			if (ValidateUtility.chkRegex("^-?\\d+", input)) {
				try {
					num = Integer.parseInt(input);
				} catch (NumberFormatException e) {
					num = 0;
				}
			}
		}
		return num;
	}

	/**
	 * _ϊ
	 * @param input		ϊO
	 * @return	ϊ㕂_
	 */
	public static double getDoubleParam(String input) {
		double dnum = 0;
		if (StringPart.isNotNull(input)) {
			try {
				dnum = Double.parseDouble(input);
			} catch (NumberFormatException e) {
				dnum = 0;
			}
		}
		return dnum;
	}

}
